//
//  $Id: WXKProgressWindowController.m 108 2009-06-24 14:54:10Z fujidana $
//  Copyright 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "WXKProgressWindowController.h"


@implementation WXKProgressWindowController


#pragma mark Class methods

+ (id)sharedWindowController;
{
	static WXKProgressWindowController *sharedWindowController;
	
	if (!sharedWindowController)
	{
		sharedWindowController = [[WXKProgressWindowController alloc] initWithWindowNibName:@"ProgressWindow"];
	}
	return sharedWindowController;
}

- (void)dealloc
{
	if (session)
	{
		[self endProgress];
	}
	[super dealloc];
}

#pragma mark Protocol of WXKProgressing

- (NSString *)message
{
	return [messageTextField stringValue];
}

- (void)setMessage:(NSString *)value
{
	[messageTextField setStringValue:value];
	if (session) [NSApp runModalSession:session];
}

- (NSString *)hint
{
	return [countTextField stringValue];
}

- (void)setHint:(NSString *)value
{
	[countTextField setStringValue:value];
	if (session) [NSApp runModalSession:session];
}

- (BOOL)isIndeterminate
{
	return [progressIndicator isIndeterminate];
}

- (void)setIndeterminate:(BOOL)flag
{
	[progressIndicator setIndeterminate:flag];
	[countTextField setHidden:flag];

	if (session) [NSApp runModalSession:session];
}

- (double)progressStep
{
	return [progressIndicator maxValue];
}

- (void)setProgressStep:(double)value
{
	[progressIndicator setMaxValue:value];
	if (session) [NSApp runModalSession:session];
}

/*
   Refresh the progress window.
*/
- (void)incrementProgressBarBy:(double)value
{
	[progressIndicator incrementBy:value];
	if (session) [NSApp runModalSession:session];
}

/*
   Return YES when user requested to abort.
*/
- (BOOL)isRequestedToAbort
{
	if (session) [NSApp runModalSession:session];
	
	return isRequestedToAbort;
}

- (void)beginProgressWithMessage:(NSString *)message
{
	[self beginProgressWithWindow:nil message:message];
}

/*
   End the session and close the progress window.
*/
- (void)endProgress
{
	if (session)
	{
		[NSApp endModalSession:session];
		
		[[self window] displayIfNeeded];
		[NSThread sleepUntilDate:[NSDate dateWithTimeIntervalSinceNow:0.25]];
		// Wait a while so that the progress indicator finishes filling the bar.
		// There might exist the better way to refreshing the window
		[progressIndicator stopAnimation:self];
		
		if ([[self window] isSheet])
		{
			[NSApp endSheet:[self window]];
		}
		[[self window] orderOut:self];
		
		session = NULL;
		isRequestedToAbort = NO;
		
		[NSApp requestUserAttention:NSInformationalRequest];
	}
}

#pragma mark Public methods

- (void)beginProgressWithWindow:(NSWindow *)window message:(NSString *)message
{
	isRequestedToAbort = NO;
	
	// If the nib file has not yet loaded, load the nib file.
	[self window];
	
	if (message != nil)
	{
		[messageTextField setStringValue:message];
	}
	[self setIndeterminate:YES];
	
	[progressIndicator setUsesThreadedAnimation:YES];
	[progressIndicator startAnimation:self];
	[progressIndicator setMinValue:0.0];
	[progressIndicator setMaxValue:1.0];
	[progressIndicator setDoubleValue:0.0];
	
	if (window)
	{
		[NSApp beginSheet:[self window]
		   modalForWindow:window
			modalDelegate:nil
		   didEndSelector:NULL
			  contextInfo:NULL];
	}
	
	session = [NSApp beginModalSessionForWindow:[self window]];
	[NSApp runModalSession:session];
}

#pragma mark Action methods

- (IBAction)requestToAbortProgress:(id)sender
{
	isRequestedToAbort = YES;
}

@end
